/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::                                                                                                          
:: Control Strategy Source Code                                             
:: (C) 2002-2009 Woodward
:: All rights reserved
::                                                              
::-----------------------------------------------------------------------------------------------------------
:: Framework API Module - Universal Set Operation functions.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

#ifndef __BITFUNCTIONS_H
#define __BITFUNCTIONS_H

/* --- INCLUDE FILES --------------------------------------------------------------------------------------*/
#include <typedefn.h>
#include <interupt.h>

/* --- DEFINES --------------------------------------------------------------------------------------------*/
#define ELEMENTS_PER_PARENT     (sizeof(SetVarType_U) * 8)



/* --- TYPEDEF --------------------------------------------------------------------------------------------*/
#pragma pack(1)

typedef struct
{
    SetVarType_U* pParents;
    SetVarType_U  CurrentParent;
    uint2 DisplayVar;
    uint2 EmptyElement;
    uint1 NumOfParents;
    uint1 CurrentParentPos;
}S_SetDisplayInfo;

typedef enum
{
    SETOPER_EXCLUDE,
    SETOPER_INCLUDE
} E_SetOper;

/* Search a mask from left to right and return with first set bit. */
#ifdef __ghs
asm SetVarType_S GetFirstActiveBit(SetVarType_U mask)
{
%reg mask
    cntlzw  r3,mask
    li      r4,31
    subf    r3,r3,r4
}
#elif defined (__GNUC__)
static inline SetVarType_S GetFirstActiveBit(SetVarType_U mask)
{
	sint4 result;
	/* count leading zeros into "result" */
    asm("cntlzw  %0, %1" : "=r" (result) : "r" (mask));
	return (31 - result);
}
#else
    #error Interrupt funcs need to be defined for the appropriate compiler
#endif

#pragma pack()

/* --- FUNCTION PROTOTYPES --------------------------------------------------------------------------------*/
bool1 IsElementInSet(SetVarType_U *pset, SetVarType_U num_parents, SetVarType_U element);
void  ResetScanning(S_SetDisplayInfo *pset_info);
bool1 TestAndModifySet(SetVarType_U *pset, SetVarType_U num_parents, SetVarType_U element, E_SetOper oper);
INLINE bool1 IsSetEmpty(S_SetDisplayInfo *pset_info);
bool1 UpdateSetStatus(S_SetDisplayInfo *pset_info);
bool1 SearchForNextElement(S_SetDisplayInfo *pset_info);

#endif /* __BITFUNCTIONS_H */


